package com.bcxin.tenant.open.rest.apis.controllers.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import lombok.Getter;

@Getter
public class EmployeeDefaultStationResponse extends ResponseAbstract {
    private final String referenceNumber;
    private final int countOfStations;

    private final boolean switch2OtherStations;

    public EmployeeDefaultStationResponse(boolean switch2OtherStations, String referenceNumber, int countOfStations) {
        this.switch2OtherStations = switch2OtherStations;
        this.referenceNumber = referenceNumber;
        this.countOfStations = countOfStations;
    }

    public static EmployeeDefaultStationResponse create(boolean switch2OtherStations, String referenceNumber, int countOfStations) {
        return new EmployeeDefaultStationResponse(switch2OtherStations,referenceNumber, countOfStations);
    }

    public boolean isCheckOtherStations() {
        return switch2OtherStations || countOfStations > 1;
    }
}
