package com.bcxin.tenant.open.rest.apis.controllers.requests;

import com.bcxin.tenant.open.jdks.requests.FlushStationPersonRequest;
import lombok.Data;

import java.util.Collection;

@Data
public class FlushDb2RedisRequest extends RequestAbstract {
    private Collection<ContentRequest> contents;
    private boolean reload;
    private boolean clearRails;
    private boolean autoUpdatedExpired;


    public static enum DataType {
        Company,
        Employee,
        Station,
        StationPersonRelative,

        /**
         * 考场
         */
        ExamRoom,
        /**
         * 考试点
         */
        ExamSite,
        /**
         * 考试
         */
        SystemExamInfo,
        RefreshCompanyPoints,
        RefreshCompanyDesks,
        User,
        CommunityUser,
        DispatchDataScope,
        SuperviseDeparts,

        TemporaryProtectionProject,
        TemporaryProtectionProjectGroup,
        TemporaryProtectionProjectMember,
        Device,
        TemporaryProtectionProjectPersonType,

        EventOrganizerJoinProject,
        EventOrganizerStationManager,
        DispatchDataSource,
        Member,
        EventOrganizerLimitedResource,
        Workstation,
        WorkStationUsers,
        WorkStationUsersBySecurityStation
    }

    @Data
    public static class ContentRequest extends RequestAbstract {
        private DataType dataType;
        private Collection<String> ids;
        private FlushStationPersonRequest stationPersonRequest;
        /**
         * 用于传递类型; 特别是驻勤点、岗点、点位的信息
         */
        private Object additionalParameter;
    }
}
