package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.jdks.QueueRpcProvider;
import com.bcxin.tenant.open.jdks.TencentCallbackLogRpcProvider;
import com.bcxin.tenant.open.jdks.requests.TencentCalculateCallLogRequest;
import com.bcxin.tenant.open.jdks.requests.TencentCallbackRequest;
import com.bcxin.tenant.open.jdks.requests.TencentQueueCallbackRequest;
import com.bcxin.tenant.open.rest.apis.configs.TencentProperty;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@RestController
@RequestMapping("/tencent/callback")
public class TencentCallbackController extends ControllerAbstract {
    private static final Logger logger = LoggerFactory.getLogger(TencentCallbackController.class);
    private final TencentCallbackLogRpcProvider tencentCallbackLogRpcProvider;
    private final JsonProvider jsonProvider;
    private final TencentProperty tencentProperty;

    private final QueueRpcProvider queueRpcProvider;

    public TencentCallbackController(TencentCallbackLogRpcProvider tencentCallbackLogRpcProvider,
                                     JsonProvider jsonProvider, TencentProperty tencentProperty, QueueRpcProvider queueRpcProvider) {
        this.tencentCallbackLogRpcProvider = tencentCallbackLogRpcProvider;
        this.jsonProvider = jsonProvider;
        this.tencentProperty = tencentProperty;
        this.queueRpcProvider = queueRpcProvider;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody Map data, HttpServletRequest request) throws IOException {
        TencentCallbackRequest tcr = TencentCallbackRequest.create(data);
        try {
            String sdkAppId = request.getHeader("SdkAppId");
            data.put("SdkAppId", sdkAppId);
            this.tencentCallbackLogRpcProvider.create(tcr);
        } catch (Exception ex) {
            logger.error("v9.执行异常", ex);
            throw ex;
        }
        StringBuilder sb = new StringBuilder();
        String matchRegionUrl = null;
        if (!CollectionUtils.isEmpty(this.tencentProperty.getCallBackItems())) {
            try {
                Map<String, Object> eventInfo = (Map<String, Object>) getByKey(data, "EventInfo");
                String userId = null;
                String roomId = null;
                if (eventInfo != null) {
                    userId = String.valueOf(getByKey(eventInfo, "UserId"));
                    roomId = String.valueOf(getByKey(eventInfo, "RoomId"));

                    sb.append(String.format("userId=%s;roomId=%s;", userId, roomId));
                } else {
                    sb.append("获取到的eventInfo信息为空");
                }

                TencentProperty.RegionPublicProperty regionPublicProperty =
                        this.tencentProperty.getMatchRegionPublic(roomId);
                if (regionPublicProperty != null) {
                    sb.append(String.format("匹配到的RegionPublicProperty=%s;url=%s", regionPublicProperty.getRoomId(), regionPublicProperty.getPublishUrl()));
                    matchRegionUrl = regionPublicProperty.getPublishUrl();
                    doCallbackPublic(
                            roomId,
                            regionPublicProperty, data);
                } else {
                    sb.append("匹配到的RegionPublicProperty=null;");
                }
            } catch (Exception ex) {
                logger.error("根据房间号匹配执行回调异常:{}", sb, ex);
            }
        } else {
            sb.append("系统配置的回调信息为:空;");
        }

        Map<String, Object> response = new HashMap<>();
        response.put("region-url", matchRegionUrl);
        response.put("code", 0);


        logger.error("收到的回调信息为(跟踪信息{}):{}", sb, jsonProvider.getJson(data));
        /**
         * 特殊的格式要求
         */
        return ResponseEntity.ok(response);
    }

    @PostMapping("/test")
    public ResponseEntity postTest(@RequestBody Map data, HttpServletRequest request) throws IOException {

        return post(data, request);
    }

    @PostMapping("/calculate")
    public ResponseEntity doCalculate(@RequestBody TencentCalculateCallLogRequest request) {
        this.tencentCallbackLogRpcProvider.execute(request);

        return this.ok("通讯计算-执行完毕-ok.");
    }


    private Object getByKey(Map<String,Object> data,String key) {
        if (key == null || data == null) {
            return null;
        }

        Optional<Object> valueOptional =
                data.entrySet().stream()
                        .filter(ix -> ix.getKey().equalsIgnoreCase(key) && ix.getValue() != null)
                        .map(ix -> ix.getValue()).findFirst();

        if (valueOptional.isPresent()) {
            return valueOptional.get();
        }

        return null;
    }

    private void doCallbackPublic(
            String roomId,
            TencentProperty.RegionPublicProperty regionPublicProperty,
                                  Map<String,Object> data) throws Exception {
        this.queueRpcProvider.dispatchTencentCallback(TencentQueueCallbackRequest.create(
                roomId,
                data,
                Stream.of(regionPublicProperty.getPublishUrl()).collect(Collectors.toList())
        ));
    }
}