package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import com.bcxin.tenant.open.jdks.TenantContentFollowWriterRpcProvider;
import com.bcxin.tenant.open.jdks.requests.DispatchContentFollowRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Tag(name = "TenantContentFollowController", description = "内容关注管理")
@RestController
@RequestMapping("/follow")
public class TenantContentFollowController extends ControllerAbstract {
    private final TenantContentFollowWriterRpcProvider contentFollowWriterRpcProvider;

    public TenantContentFollowController(
            TenantContentFollowWriterRpcProvider contentFollowWriterRpcProvider
    ) {
        this.contentFollowWriterRpcProvider = contentFollowWriterRpcProvider;
    }

    @Operation(
            summary = "关注", description = "关注保安人员, 驻勤点及智能设备信息",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回ok.")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken"),
                    @Parameter(in = ParameterIn.PATH, required = true, name = "followType",
                            description = "Employee: 关注保安人员; Station: 关注驻勤点; Device: 智能设备"),
                    @Parameter(in = ParameterIn.PATH, required = true, name = "contentId",
                            description = "对应保安人员/驻勤点/设备的Id")
            }
    )
    @PostMapping("/{followType}/{contentId}")
    public ResponseEntity doPost(@PathVariable ContentFollowType followType,
                                 @PathVariable String contentId) {
        DispatchContentFollowRequest request =
                DispatchContentFollowRequest.create(
                        followType, contentId, true
                );

        this.contentFollowWriterRpcProvider.doPatch(request);

        return this.ok();
    }

    @Operation(
            summary = "取消关注", description = "取消关注保安人员, 驻勤点及智能设备信息",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回ok.")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken"),
                    @Parameter(in = ParameterIn.PATH, required = true, name = "followType",
                            description = "Employee: 关注保安人员; Station: 关注驻勤点; Device: 智能设备"),
                    @Parameter(in = ParameterIn.PATH, required = true, name = "contentId",
                            description = "对应保安人员/驻勤点/设备的Id")
            }
    )
    @DeleteMapping("/{followType}/{contentId}")
    public ResponseEntity doDelete(@PathVariable ContentFollowType followType,
                                   @PathVariable String contentId) {
        DispatchContentFollowRequest request =
                DispatchContentFollowRequest.create(
                        followType, contentId, false
                );

        this.contentFollowWriterRpcProvider.doPatch(request);

        return this.ok();
    }
}
