package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.SyncSlaveWriterRpcProvider;
import com.bcxin.tenant.open.jdks.requests.SyncSlaveWriterRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/sync-slave")
public class SyncSlaveController extends ControllerAbstract {
    private static Logger logger = LoggerFactory.getLogger(SyncSlaveController.class);

    private final SyncSlaveWriterRpcProvider syncSlaveWriterRpcProvider;

    public SyncSlaveController(SyncSlaveWriterRpcProvider syncSlaveWriterRpcProvider) {
        this.syncSlaveWriterRpcProvider = syncSlaveWriterRpcProvider;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody SyncSlaveWriterRequest request) {
        this.syncSlaveWriterRpcProvider.flush(request);

        return this.ok();
    }
}
