package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.RollCallPlanRpcProvider;
import com.bcxin.tenant.open.jdks.requests.RollCallPlanRequest;
import com.bcxin.tenant.open.jdks.requests.RollCallPlanSearchRequest;
import com.bcxin.tenant.open.jdks.responses.RollCallPlanDetailResponse;
import com.bcxin.tenant.open.jdks.responses.RollCallPlanResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Tag(name = "RollCallPlanController", description = "点名计划")
@RestController
@RequestMapping("/roll-call-plans")
public class RollCallPlanController extends ControllerAbstract {
    private final RollCallPlanRpcProvider rollCallPlanRpcProvider;

    public RollCallPlanController(RollCallPlanRpcProvider rollCallPlanRpcProvider) {
        this.rollCallPlanRpcProvider = rollCallPlanRpcProvider;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody RollCallPlanRequest request) {
        this.rollCallPlanRpcProvider.create(request);

        return this.ok();
    }

    @PutMapping("/{id}")
    public ResponseEntity put(@PathVariable long id, @RequestBody RollCallPlanRequest request) {
        this.rollCallPlanRpcProvider.update(id, request);

        return this.ok();
    }

    @DeleteMapping("/{id}")
    public ResponseEntity delete(@PathVariable long id) {
        this.rollCallPlanRpcProvider.delete(id);

        return this.ok();
    }

    @PostMapping("/search")
    public ResponseEntity search(@RequestBody RollCallPlanSearchRequest request) {
        EntityCollection<RollCallPlanResponse> response = this.rollCallPlanRpcProvider.search(request);
        return this.ok(response);
    }

    @GetMapping("/{id}")
    public ResponseEntity get(@PathVariable long id) {
        RollCallPlanDetailResponse response = this.rollCallPlanRpcProvider.get(id);
        if (response == null) {
            return this.notFound();
        }

        return this.ok(response);
    }
}