package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.ProjectRoadmapRpcProvider;
import com.bcxin.tenant.open.jdks.requests.ProjectRoadmapRequest;
import com.bcxin.tenant.open.jdks.requests.ProjectRoadmapSearchRequest;
import com.bcxin.tenant.open.jdks.responses.ProjectRoadmapResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

@Tag(name = "ProjectRoadmapController", description = "项目路线图")
@RestController
@RequestMapping("/project-roadmaps")
public class ProjectRoadmapController extends ControllerAbstract {
    private final ProjectRoadmapRpcProvider projectRoadmapRpcProvider;

    public ProjectRoadmapController(ProjectRoadmapRpcProvider projectRoadmapRpcProvider) {
        this.projectRoadmapRpcProvider = projectRoadmapRpcProvider;
    }

    @Operation(
            summary = "项目路线列表", description = "项目路线列表:详情信息直接取列表返回的各项数据；无需请求API",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回项目路线列表."),
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping("/search")
    public ResponseEntity<EntityCollection<ProjectRoadmapResponse>> search(@RequestBody ProjectRoadmapSearchRequest request) {
        if (CollectionUtils.isEmpty(request.getProjectIds())) {
            return this.ok(EntityCollection.EMPTY());
        }

        var data = this.projectRoadmapRpcProvider.search(request);
        return this.ok(data);
    }

    @Operation(
            summary = "新增路线", description = "新增路线",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回."),
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken")
            }
    )
    @PostMapping
    public ResponseEntity post(@RequestBody ProjectRoadmapRequest request) {

        this.projectRoadmapRpcProvider.create(request);
        return this.ok();
    }

    @Operation(
            summary = "修改路线信息", description = "修改路线信息",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回."),
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken"),
                    @Parameter(in = ParameterIn.DEFAULT, required = true, name = "id", description = "路线Id")
            }
    )
    @PutMapping("/{id}")
    public ResponseEntity put(@PathVariable Long id, @RequestBody ProjectRoadmapRequest request) {

        this.projectRoadmapRpcProvider.update(id,request);
        return this.ok();
    }

    @Operation(
            summary = "删除路线信息", description = "删除路线信息",
            responses = {
                    @ApiResponse(responseCode = "200", description = "成功返回."),
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken"),
                    @Parameter(in = ParameterIn.DEFAULT, required = true, name = "id", description = "路线Id"),
            }
    )
    @DeleteMapping("/{id}")
    public ResponseEntity put(@PathVariable Long id) {

        this.projectRoadmapRpcProvider.delete(id);
        return this.ok();
    }
}
