package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.OrgPurseRpcProvider;
import com.bcxin.tenant.open.jdks.requests.OrgPursePointRequest;
import com.bcxin.tenant.open.jdks.responses.OrgPurseValidateResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;

import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name = "OrgPurseController", description = "联动值验证")
@RestController
@RequestMapping("/org-purses")
public class OrgPurseController extends ControllerAbstract {
    private final OrgPurseRpcProvider orgPurseRpcProvider;

    public OrgPurseController(OrgPurseRpcProvider orgPurseRpcProvider) {
        this.orgPurseRpcProvider = orgPurseRpcProvider;
    }

    @Operation(
            summary = "联动值验证", description = "验证加入房间的企业是否有足够的联动值;",
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回可被调度的企业信息."),
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "accessToken",
                            description = "来自V5的accessToken")
            }
    )
    @PostMapping("/points-validate")
    public ResponseEntity<OrgPurseValidateResponse> pointValidate(@RequestBody @Validated OrgPursePointRequest request) {
        OrgPurseValidateResponse response =
                this.orgPurseRpcProvider.validate(request);

        return this.ok(response);
    }
}
