package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.rest.apis.controllers.requests.MessageRequest;
import com.bcxin.tenant.open.rest.apis.controllers.responses.MessageResponse;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.stereotype.Controller;

import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;

@Controller
public class MessageController extends ControllerAbstract {
    /**
     * https://docs.spring.io/spring/reference/web/websocket/stomp/handle-annotations.html
     */
    private final SimpMessagingTemplate simpMessagingTemplate;

    public MessageController(SimpMessagingTemplate simpMessagingTemplate) {
        this.simpMessagingTemplate = simpMessagingTemplate;
    }

    /**
     * registry.setApplicationDestinationPrefixes("/dispatch/websocket/app");
     * 作为这个的前缀
     * @param message
     * @return
     * @throws Exception
     */
    @MessageMapping("/chat")
    @SendTo("/dispatch/websocket/topic/messages")
    public MessageResponse send(MessageRequest message) throws Exception {
        String time = new SimpleDateFormat("HH:mm").format(new Date());

        return MessageResponse.create(time, message.getText());
    }

    @MessageMapping("/websocket/messages")
    @SendToUser("/queue/reply")
    public String processMessageFromClient(@Payload String message, Principal principal) throws Exception {
        return message;
    }

    @MessageExceptionHandler
    @SendToUser("/queue/errors")
    public String handleException(Throwable exception) {
        return exception.getMessage();
    }

    /**
     * 用于返回信息给订阅者
     * https://docs.spring.io/spring/reference/web/websocket/stomp/handle-annotations.html#websocket-stomp-subscribe-mapping
     * @return
     */
    @SubscribeMapping("/chat")
    public String receive()
    {
        return "";
    }
}