package com.bcxin.tenant.open.rest.apis.controllers;

import com.bcxin.tenant.open.jdks.AttendanceRpcProvider;
import com.bcxin.tenant.open.jdks.requests.AttendanceSearchByTypeRequest;
import com.bcxin.tenant.open.jdks.responses.AttendanceResponse;
import com.bcxin.tenant.open.rest.apis.utils.JwtUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

@Tag(name = "DataQueryController", description = "聚合数据查询")
@RestController
@RequestMapping("/data-query")
public class DataQueryController extends ControllerAbstract {
    private static final Logger logger = LoggerFactory.getLogger(AttendanceController.class);
    private final AttendanceRpcProvider attendanceRpcProvider;

    public DataQueryController(AttendanceRpcProvider attendanceRpcProvider) {
        this.attendanceRpcProvider = attendanceRpcProvider;
    }

    @Operation(summary = "签到数据查询-根据业务类型进行搜索（根据任务类型和Id）", description = "根据业务类型进行搜索（根据任务类型和Id）",
            requestBody =
            @io.swagger.v3.oas.annotations.parameters.RequestBody(
                    required = true),
            responses = {
                    @ApiResponse(responseCode = "200", description = "返回相关的签到信息")
            },
            parameters = {
                    @Parameter(in = ParameterIn.HEADER, required = true, name = "dispatchToken",
                            description = "来自认证接口产生的调度系统的/identity/auto-login产生的dispatchToken"),
                    @Parameter(in = ParameterIn.QUERY, required = true, name = "permission",
                            description = "固定传:advance 表示根据用户当前的权限而非依赖于调度台来实现权限管理; 不支持监管方")
            }
    )
    @PostMapping("/attendance/search-by-references")
    public ResponseEntity<Collection<AttendanceResponse>> searchByAttendanceType(
            @RequestHeader("accessToken") String accessToken,
            @RequestBody AttendanceSearchByTypeRequest request) {

        String employeeId = JwtUtil.getUserIdFromToken(accessToken);

        if (!StringUtils.hasLength(employeeId)) {
            return this.status(HttpStatus.UNAUTHORIZED, "未授权用户");
        }
        
        Collection<AttendanceResponse> data = this.attendanceRpcProvider.search(request);

        return this.ok(data);
    }
}
