package com.bcxin.tenant.open.rest.apis.configs;

import com.bcxin.tenant.open.infrastructures.configs.TenantSystemConfig;
import com.bcxin.tenant.open.jdks.*;
import org.apache.dubbo.common.constants.ClusterRules;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;


@Configuration
@ComponentScan(basePackages = "com.bcxin.tenant")
public class WebConfig {
    @DubboReference
    private final EmployeeReaderRpcProvider employeeReaderRpcProvider;

    @DubboReference(timeout = 300*1000)
    private final EmployeeWriterRpcProvider employeeWriterRpcProvider;

    @DubboReference
    private final DepartmentlevelRpcProvider departmentlevelRpcProvider;

    @DubboReference
    private final PoliceIncidentsRpcProvider policeIncidentsRpcProvider;

    @DubboReference
    private final AttendanceRpcProvider attendanceRpcProvider;

    @DubboReference
    private final UserWriterRpcProvider userWriterRpcProvider;

    @DubboReference
    private final CompanyReaderRpcProvider companyReaderRpcProvider;

    @DubboReference(timeout = 300*1000)
    private final SecurityStationWriterRpcProvider securityStationWriterRpcProvider;

    @DubboReference
    private final SecurityStationReaderRpcProvider securityStationReaderRpcProvider;

    @DubboReference(timeout = 300*1000)
    private final CompanyWriterRpcProvider companyWriterRpcProvider;

    @DubboReference(methods = {
         //   @Method(name = "")
    })
    private final IdentityRpcProvider identityRpcProvider;

    @DubboReference
    private final TencentCallbackLogRpcProvider tencentCallbackLogRpcProvider;

    @DubboReference
    private final OrgPurseRpcProvider orgPurseRpcProvider;

    @DubboReference
    private final DispatchLogRpcProvider dispatchLogRpcProvider;

    @DubboReference
    private final SecurityStationPersonWriterRpcProvider securityStationPersonWriterRpcProvider;

    @DubboReference
    private final RoomRpcProvider roomRpcProvider;

    @DubboReference
    private final SyncSlaveWriterRpcProvider syncSlaveWriterRpcProvider;

    @DubboReference
    private final RdSyncEventRpcProvider syncEventRpcProvider;

    @DubboReference
    private final RdSecurityStationRailWriterRpcProvider rdSecurityStationRailWriterRpcProvider;

    @DubboReference
    private final QueueRpcProvider queueRpcProvider;

    @DubboReference
    private final TenantContentFollowWriterRpcProvider contentFollowWriterRpcProvider;

    @DubboReference
    private final SecurityStationRailMessageRpcProvider securityStationRailMessageRpcProvider;

    @DubboReference
    private final TenantAccountWriterRpcProvider tenantAccountWriterRpcProvider;

    @DubboReference
    private final RdSyncRpcWriterProvider syncRpcWriterProvider;

    @DubboReference
    private final TenantWarnContentRpcProvider tenantWarnContentRpcProvider;

    @DubboReference
    private final AnalyticsLogRpcProvider analyticsLogRpcProvider;

    @DubboReference
    private final CommunityUserWriterRpcProvider communityUserWriterRpcProvider;

    @DubboReference
    private final DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider;

     @DubboReference
    private final ExamRoomRpcProvider examRoomRpcProvider;

    @DubboReference
    private final ExamSiteWriterRpcProvider examSiteRpcProvider;

    @DubboReference
    private final SystemExamInfoRpcProvider systemExamInfoRpcProvider;

    @DubboReference
    private final ExamSiteRoomReaderRpcProvider examSiteRoomReaderRpcProvider;

    @DubboReference
    private final ExamSiteReaderRpcProvider examSiteReaderRpcProvider;


     @DubboReference
    private final RollCallPlanRpcProvider rollCallPlanRpcProvider;

    @DubboReference
    private final RollCallWriterRpcProvider rollCallWriterRpcProvider;

    @DubboReference
    private final RollCallEmployeeReaderRpcProvider rollCallEmployeeReaderRpcProvider;

    @DubboReference
    private final NotifyMessageRpcProvider notifyMessageRpcProvider;

    @DubboReference
    private final ProjectWriterRpcProvider projectWriterRpcProvider;

    @DubboReference
    private final ProjectReaderRpcProvider projectReaderRpcProvider;
    @DubboReference
    private final ProjectTeamMemberRpcProvider projectTeamMemberRpcProvider;

        @DubboReference
    private final DeviceReaderRpcProvider deviceReaderRpcProvider;

    @DubboReference
    private final DeviceWriterRpcProvider deviceWriterRpcProvider;

    @DubboReference
    private final HotCacheRpcProvider hotCacheRpcProvider;

    @DubboReference
    private final DynamicStationTypeWriterRpcProvider dynamicStationTypeWriterRpcProvider;
    @DubboReference
    private final DispatchDataSourceRpcProvider dispatchDataSourceRpcProvider;

    @DubboReference
    private final ProjectRoadmapRpcProvider projectRoadmapRpcProvider;

    @DubboReference(cluster = ClusterRules.BROADCAST)
    private final CacheWriterProvider cacheWriterProvider;

    @DubboReference
    private final ThirdDeviceRpcProvider thirdDeviceRpcProvider;

    @DubboReference
    private final WorkstationRpcProvider workstationRpcProvider;

     @DubboReference
    private final StationDeviceRpcProvider stationDeviceRpcProvider;
    
    public WebConfig(EmployeeReaderRpcProvider employeeReaderRpcProvider,
                     EmployeeWriterRpcProvider employeeWriterRpcProvider,
                     DepartmentlevelRpcProvider departmentlevelRpcProvider,
                     PoliceIncidentsRpcProvider policeIncidentsRpcProvider,
                     AttendanceRpcProvider attendanceRpcProvider,
                     UserWriterRpcProvider userWriterRpcProvider,
                     CompanyReaderRpcProvider companyReaderRpcProvider,
                     SecurityStationWriterRpcProvider securityStationWriterRpcProvider,
                     SecurityStationReaderRpcProvider securityStationReaderRpcProvider,
                     CompanyWriterRpcProvider companyWriterRpcProvider,
                     IdentityRpcProvider identityRpcProvider,
                     TencentCallbackLogRpcProvider tencentCallbackLogRpcProvider,
                     OrgPurseRpcProvider orgPurseRpcProvider,
                     DispatchLogRpcProvider dispatchLogRpcProvider,
                     SecurityStationPersonWriterRpcProvider securityStationPersonWriterRpcProvider,
                     RoomRpcProvider roomRpcProvider,
                     SyncSlaveWriterRpcProvider syncSlaveWriterRpcProvider,
                     RdSyncEventRpcProvider syncEventRpcProvider,
                     RdSecurityStationRailWriterRpcProvider rdSecurityStationRailWriterRpcProvider,
                     QueueRpcProvider queueRpcProvider,
                     TenantContentFollowWriterRpcProvider contentFollowWriterRpcProvider,
                     SecurityStationRailMessageRpcProvider securityStationRailMessageRpcProvider,
                     TenantAccountWriterRpcProvider tenantAccountWriterRpcProvider, RdSyncRpcWriterProvider syncRpcWriterProvider, TenantWarnContentRpcProvider tenantWarnContentRpcProvider, AnalyticsLogRpcProvider analyticsLogRpcProvider, CommunityUserWriterRpcProvider communityUserWriterRpcProvider, DispatchDataScopeRpcProvider dispatchDataScopeRpcProvider,
                     ExamRoomRpcProvider examRoomRpcProvider,
                     ExamSiteWriterRpcProvider examSiteRpcProvider,
                     SystemExamInfoRpcProvider systemExamInfoRpcProvider,
                     ExamSiteRoomReaderRpcProvider examSiteRoomReaderRpcProvider,
                     ExamSiteReaderRpcProvider examSiteReaderRpcProvider,
                     RollCallPlanRpcProvider rollCallPlanRpcProvider,
                     RollCallWriterRpcProvider rollCallWriterRpcProvider,
                     RollCallEmployeeReaderRpcProvider rollCallEmployeeReaderRpcProvider,
                     NotifyMessageRpcProvider notifyMessageRpcProvider,
                     ProjectWriterRpcProvider projectWriterRpcProvider,
                     ProjectReaderRpcProvider projectReaderRpcProvider,
                     ProjectTeamMemberRpcProvider projectTeamMemberRpcProvider,
                     DeviceReaderRpcProvider deviceReaderRpcProvider,
                     DeviceWriterRpcProvider deviceWriterRpcProvider,
                     HotCacheRpcProvider hotCacheRpcProvider,
                     DynamicStationTypeWriterRpcProvider dynamicStationTypeWriterRpcProvider,
                     DispatchDataSourceRpcProvider dispatchDataSourceRpcProvider,
                     ProjectRoadmapRpcProvider projectRoadmapRpcProvider,
                     CacheWriterProvider cacheWriterProvider,
                     ThirdDeviceRpcProvider thirdDeviceRpcProvider,
                     WorkstationRpcProvider workstationRpcProvider, StationDeviceRpcProvider stationDeviceRpcProvider) {
        this.employeeReaderRpcProvider = employeeReaderRpcProvider;
        this.employeeWriterRpcProvider = employeeWriterRpcProvider;
        this.departmentlevelRpcProvider = departmentlevelRpcProvider;
        this.policeIncidentsRpcProvider = policeIncidentsRpcProvider;
        this.attendanceRpcProvider = attendanceRpcProvider;
        this.userWriterRpcProvider = userWriterRpcProvider;
        this.companyReaderRpcProvider = companyReaderRpcProvider;
        this.securityStationWriterRpcProvider = securityStationWriterRpcProvider;
        this.securityStationReaderRpcProvider = securityStationReaderRpcProvider;
        this.companyWriterRpcProvider = companyWriterRpcProvider;
        this.identityRpcProvider = identityRpcProvider;
        this.tencentCallbackLogRpcProvider = tencentCallbackLogRpcProvider;
        this.orgPurseRpcProvider = orgPurseRpcProvider;
        this.dispatchLogRpcProvider = dispatchLogRpcProvider;
        this.securityStationPersonWriterRpcProvider = securityStationPersonWriterRpcProvider;
        this.roomRpcProvider = roomRpcProvider;
        this.syncSlaveWriterRpcProvider = syncSlaveWriterRpcProvider;
        this.syncEventRpcProvider = syncEventRpcProvider;
        this.rdSecurityStationRailWriterRpcProvider = rdSecurityStationRailWriterRpcProvider;
        this.queueRpcProvider = queueRpcProvider;
        this.contentFollowWriterRpcProvider = contentFollowWriterRpcProvider;
        this.securityStationRailMessageRpcProvider = securityStationRailMessageRpcProvider;
        this.tenantAccountWriterRpcProvider = tenantAccountWriterRpcProvider;
        this.syncRpcWriterProvider = syncRpcWriterProvider;
        this.tenantWarnContentRpcProvider = tenantWarnContentRpcProvider;
        this.analyticsLogRpcProvider = analyticsLogRpcProvider;
        this.communityUserWriterRpcProvider = communityUserWriterRpcProvider;
        this.dispatchDataScopeRpcProvider = dispatchDataScopeRpcProvider;

        this.examRoomRpcProvider = examRoomRpcProvider;
        this.examSiteRpcProvider = examSiteRpcProvider;
        this.systemExamInfoRpcProvider = systemExamInfoRpcProvider;
        this.examSiteRoomReaderRpcProvider = examSiteRoomReaderRpcProvider;
        this.examSiteReaderRpcProvider = examSiteReaderRpcProvider;
        this.rollCallPlanRpcProvider = rollCallPlanRpcProvider;
        this.rollCallWriterRpcProvider = rollCallWriterRpcProvider;
        this.rollCallEmployeeReaderRpcProvider = rollCallEmployeeReaderRpcProvider;
        this.notifyMessageRpcProvider = notifyMessageRpcProvider;
        this.projectWriterRpcProvider = projectWriterRpcProvider;
        this.projectReaderRpcProvider = projectReaderRpcProvider;
        this.projectTeamMemberRpcProvider = projectTeamMemberRpcProvider;

        this.deviceReaderRpcProvider = deviceReaderRpcProvider;
        this.deviceWriterRpcProvider = deviceWriterRpcProvider;
        this.hotCacheRpcProvider = hotCacheRpcProvider;
        this.dynamicStationTypeWriterRpcProvider = dynamicStationTypeWriterRpcProvider;
        this.dispatchDataSourceRpcProvider = dispatchDataSourceRpcProvider;
        this.projectRoadmapRpcProvider = projectRoadmapRpcProvider;
        this.cacheWriterProvider = cacheWriterProvider;
        this.thirdDeviceRpcProvider = thirdDeviceRpcProvider;
        this.workstationRpcProvider = workstationRpcProvider;
        this.stationDeviceRpcProvider = stationDeviceRpcProvider;
    }


    @Bean
    public FilterRegistrationBean corsFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        final CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(true); // 允许cookies跨域
        config.addAllowedOriginPattern("*");
        //config.addAllowedOrigin("*");// #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
        config.addAllowedHeader("*");// #允许访问的头信息,*表示全部
        config.setMaxAge(18000L);// 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
        config.addAllowedMethod("*");// 允许提交请求的方法，*表示全部允许
        source.registerCorsConfiguration("/**", config);
        filterRegistrationBean.setFilter(new CorsFilter(source));
        filterRegistrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);

        return filterRegistrationBean;
    }

    /**
     * 站点所在的区域
     * @param regionCode
     * @return
     */
    @Bean
    public TenantSystemConfig tenantSystemConfig(@Value("${tenant.system.region-code:}")String regionCode) {
        return new TenantSystemConfig(regionCode);
    }
}