package com.bcxin.tenant.open.rest.apis.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;

@ConfigurationProperties("tenant.tencent")
@Component
@Data
public class TencentProperty {

    private Collection<RegionPublicProperty> callBackItems;

    @Data
    public static class RegionPublicProperty {
        private String roomId;
        private String publishUrl;
    }

    public RegionPublicProperty getMatchRegionPublic(String roomId) {
        if (CollectionUtils.isEmpty(this.getCallBackItems()) || !StringUtils.hasLength(roomId)) {
            return null;
        }

        return this.getCallBackItems().stream()
                .filter(ii -> roomId.startsWith(ii.getRoomId()))
                .findFirst().orElse(null);
    }
}
