package com.bcxin.tenant.open.rest.apis.configs;
import com.bcxin.tenant.open.dubbo.common.configs.DubboConfigProperty;
import com.bcxin.tenant.open.infrastructures.components.DefaultIdWorkerImpl;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableDubbo(scanBasePackages = "com.bcxin.tenant.open.rest.apis.impls")
public class DubboConfig {
    @Bean
    public ConsumerConfig registryConfig(DubboConfigProperty property) {
        ConsumerConfig config = new ConsumerConfig();
        config.setCheck(false);
        /**
         * 不过期
         */
        config.setTimeout(120 * 1000);
        /**
         * 禁用重试
         */
        config.setRetries(0);
        config.setVersion(property.getVersion());

        return config;
    }

    @Bean
    public IdWorker idWorker() {
        return new DefaultIdWorkerImpl();
    }
}
