package com.bcxin.tenant.open.rest.apis.caches;

import lombok.Data;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Set;

@Data
public class TenantSecurityEmployeeCache extends CacheAbstract {
    /**
     * 最新的驻勤信息
     */
    private  String securityStationId;
    /**
     * 最新的驻勤名称
     */
    private  String securityStationName;
    /**
     * 最新的监管归属信息
     */
    private  String superviseDepartId;

    /**
     * 最新的监管归属名称
     */
    private  String superviseDepartName;
    /**
     * 最新的腾讯资源信息
     */
    private  String tencentUserId;

    /**
     * 用户姓名
     */
    private  String tenantUserName;

    /**
     * 用户身份证
     */
    private  String tenantUserIdCard;
    private  Set<String> resourceTypes;

    private Timestamp createdTime;

    public TenantSecurityEmployeeCache() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static TenantSecurityEmployeeCache create(String securityStationId, String securityStationName,
                                                                           String superviseDepartId, String tencentUserId,
                                                                           String tenantUserName, String tenantUserIdCard,
                                                                           String superviseDepartName,
                                                                           Set<String> resourceTypes) {
        TenantSecurityEmployeeCache cache = new TenantSecurityEmployeeCache();

        cache.securityStationId = securityStationId;
        cache.securityStationName = securityStationName;
        cache.superviseDepartId = superviseDepartId;
        cache.tencentUserId = tencentUserId;
        cache.tenantUserName = tenantUserName;
        cache.tenantUserIdCard = tenantUserIdCard;
        cache.superviseDepartName = superviseDepartName;
        cache.resourceTypes = resourceTypes;

        return cache;
    }
}
