package com.bcxin.tenant.open.rest.apis.caches;

import lombok.Data;

import java.util.ArrayList;
import java.util.Collection;

public class OrgPurseCache  extends CacheAbstract {

    private Collection<OrgPurseItemCache> orgPurseItems;

    public Collection<OrgPurseItemCache> getOrgPurseItems() {
        if (orgPurseItems == null) {
            orgPurseItems = new ArrayList<>();
        }

        return orgPurseItems;
    }

    public void setOrgPurseItems(Collection<OrgPurseItemCache> itemCaches) {
        this.orgPurseItems = itemCaches;
    }

    public static OrgPurseCache create(Collection<OrgPurseItemCache> orgPurseItems) {
        OrgPurseCache cache = new OrgPurseCache();
        cache.setOrgPurseItems(orgPurseItems);

        return cache;
    }

    @Data
    public static class OrgPurseItemCache extends CacheAbstract {
        private String organizationId;
        private boolean dispatchable;

        /**
         * 留着给序列化使用
         */
        public OrgPurseItemCache() {
        }

        public OrgPurseItemCache(String organizationId, boolean dispatchable) {
            this.organizationId = organizationId;
            this.dispatchable = dispatchable;
        }

        public static OrgPurseItemCache create(String organizationId, boolean dispatchable) {

            return new OrgPurseItemCache(organizationId, dispatchable);
        }
    }
}
