package com.bcxin.tenant.open.rest.apis.caches;

import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;

public class CacheKeyManage {
    private static final String CACHE_PREFIX_LABEL="rt-v1";

    public static String getUserSetting(DispatchAccountType accountType, String employeeId) {
        return String.format("%s:crt_%s_setting_%s", CACHE_PREFIX_LABEL,accountType,employeeId);
    }

    public static String getOrgBasicKey(String orgId) {
        return String.format("%s:org_basic_%s", CACHE_PREFIX_LABEL,orgId);
    }

    public static String getUserCurrentDutyStatus(String employeeId) {
        return String.format("%s:crt_%s_duty_status",CACHE_PREFIX_LABEL, employeeId);
    }

    public static String getUserInfoFromAuthFilterKey(String employeeId, DeskType deskType) {
        return String.format("%s:crt_%s_auth_filter_%s",CACHE_PREFIX_LABEL, deskType,employeeId);
    }

    public static String getOrgPurseCacheKey(String orgId) {
        return String.format("%s:org_purse_%s", CACHE_PREFIX_LABEL,orgId);
    }

    public static String getEmpDetailKey(String employeeId) {
        return String.format("%s:emp_%s",CACHE_PREFIX_LABEL, employeeId);
    }

    public static String getHotAttStationBasicKey(String stationId) {
        return String.format("%s:att_sta_v2_%s", CACHE_PREFIX_LABEL,stationId);
    }

    public static String getEmpDeskPermissionKey(String employeeId,DispatchAccountType accountType) {
        return String.format("%s:emp_desk_v8_%s",CACHE_PREFIX_LABEL, employeeId);
    }

    public static String getDispatchDataSourceKey(String thirdParty) {
        return String.format("%s:dd_sour_%s",CACHE_PREFIX_LABEL, thirdParty);
    }

    public static String getHotEmployeeStationId(String employeeId) {
        return String.format("%s:st_id_%s", CACHE_PREFIX_LABEL, employeeId);
    }

    public static String getHotAttendanceActionCode(String actionCode) {
        return String.format("%s:att_code_%s", CACHE_PREFIX_LABEL, actionCode);
    }

    public static String getHotAccessLocalEmpIdCache(String accessToken) {
        return String.format("%s:local_access_%s", CACHE_PREFIX_LABEL, accessToken);
    }

    /**
     * todo: 20250527: 更新点位信息的时候, 刷新工作点列表信息
     * 人员所在点变化，点基本信息变化
     * @param employeeId
     * @return
     */
    public static String getHotWorkstationByEmployeeId(String employeeId) {
        return String.format("%s:wks_id_%s", CACHE_PREFIX_LABEL, employeeId);
    }
}
