package com.bcxin.tenant.open.domains.views;

import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.PointChangeType;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import lombok.Data;

import java.util.Map;

@Data
public class TencentCallbackLogView  extends EntityAbstract implements Aggregate {
    /**
     * 音视频回调Id
     */
    private Long id;

    /**
     * 事件组
     */
    private Long eventGroupId;

    /**
     * 回调的事件
     */
    private Long callbackTs;

    /**
     * 事件发生事件
     */
    public Long getEventMsTs(JsonProvider jsonProvider) {
        if (this.getEventInfo() == null || this.getEventInfo() == "") {
            return -1L;
        }

        Map mapValue = jsonProvider.toObject(Map.class, this.getEventInfo());
        if (mapValue == null || !mapValue.containsKey("EventMsTs")) {
            return -1L;
        }

        Long eventTs = Long.parseLong(mapValue.get("EventMsTs").toString());

        return eventTs;
    }

    /**
     * 腾讯音视频的事件类型
     */
    private Long eventType;

    /**
     * 腾讯音视频的UserId:
     * deviceNo或者TenantUser.ImIdentity
     */
    private String tencentUserId;

    /**
     * 腾讯音视频的房间Id
     */
    private String roomId;

    private String eventInfo;


    public PointChangeType getChangeType() {
        if (this.getEventType() == 203 || this.getEventType() == 204) {
            return PointChangeType.AudioCost;
        }

        if (this.getEventType() == 201 || this.getEventType() == 202) {
            return PointChangeType.VideoCost;
        }

        if (this.getEventType() == 205 || this.getEventType() == 206) {
            return PointChangeType.AuxiliaryData;
        }

        throw new NotSupportTenantException(String.format("不支持该类型:%s", this.getEventType()));
    }
}
