package com.bcxin.tenant.open.domains.services.commands.results;

import com.bcxin.tenant.open.infrastructures.commands.results.CommandResultAbstract;
import lombok.Getter;

@Getter
public class ValidateAttendanceCommandResult extends CommandResultAbstract {
    private final String id;
    private final String name;
    private final String address;
    private final Double latitude;
    private final Double longitude;
    private final Double performRange;
    private boolean enableFaceValidation;

    private final boolean ignoredPerformRangeLimited;

    public ValidateAttendanceCommandResult(String id, String name, String address, Double latitude, Double longitude,
                                           Double performRange,
                                           boolean ignoredPerformRangeLimited) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.latitude = latitude;
        this.longitude = longitude;
        this.performRange = performRange;
        this.ignoredPerformRangeLimited = ignoredPerformRangeLimited;
    }

    public static ValidateAttendanceCommandResult create(String id, String name, String address, Double latitude, Double longitude, Double performRange,
                                                         boolean ignoredPerformRangeLimited) {
        return new ValidateAttendanceCommandResult(id, name, address, latitude, longitude, performRange, ignoredPerformRangeLimited);
    }

    public void assignEnableFaceValidation(boolean enableFaceValidation) {
        this.enableFaceValidation = enableFaceValidation;
    }
}
