package com.bcxin.tenant.open.domains.services.commands.results;

import com.bcxin.tenant.open.infrastructures.commands.results.CommandResultAbstract;
import lombok.Getter;

@Getter
public class CreateRollCallCommandResult extends CommandResultAbstract {
    private final Long rollCallId;
    private final int countOfRollCallPerson;

    public CreateRollCallCommandResult(Long rollCallId, int countOfRollCallPerson) {
        this.rollCallId = rollCallId;
        this.countOfRollCallPerson = countOfRollCallPerson;
    }

    public static CreateRollCallCommandResult create(Long rollCallId, int countOfRollCallPerson) {
        return new CreateRollCallCommandResult(rollCallId, countOfRollCallPerson);
    }
}
