package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.util.Date;

/**
 * 更新警情
 */
@Getter
public class UpdatePoliceIncidentsCommand extends CommandAbstract {
    private final Long id;
    private final PoliceEventStatus policeEventStatus;
    private final String actionTaken;
    private final String actionTendency;
    private final String processedSuggestion;
    private final String processedLocaleGuidance;
    private final int points;

    public UpdatePoliceIncidentsCommand(Long id, PoliceEventStatus policeEventStatus, String actionTaken, String actionTendency,
                                        String processedSuggestion, String processedLocaleGuidance,int points) {
        this.id = id;
        this.policeEventStatus = policeEventStatus;
        this.actionTaken = actionTaken;
        this.actionTendency = actionTendency;
        this.processedSuggestion = processedSuggestion;
        this.processedLocaleGuidance = processedLocaleGuidance;
        this.points = points;
    }

    public static UpdatePoliceIncidentsCommand create(Long id, PoliceEventStatus policeEventStatus, String actionTaken, String actionTendency,
                                                      String processedSuggestion, String processedLocaleGuidance,int points) {
        return new UpdatePoliceIncidentsCommand(id, policeEventStatus, actionTaken, actionTendency, processedSuggestion, processedLocaleGuidance,points);
    }
}
