package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import lombok.Getter;

import java.util.Collection;

@Getter
public class RollCallBatchEmployeeRoomActionCommand extends CommandAbstract {
    private final Collection<RollCallReplyEmployeeCommandItem> items;

    public RollCallBatchEmployeeRoomActionCommand(Collection<RollCallReplyEmployeeCommandItem> items) {
        this.items = items;
    }

    public static RollCallBatchEmployeeRoomActionCommand create(Collection<RollCallReplyEmployeeCommandItem> items) {
        return new RollCallBatchEmployeeRoomActionCommand(items);
    }

    @Getter
    public static class RollCallReplyEmployeeCommandItem {
        private final Long rollCallId;
        private final String employeeId;
        private final String instantActiveDocId;
        private final RollCallStatus callStatus;

        private final String roomId;

        public RollCallReplyEmployeeCommandItem(Long rollCallId,String employeeId, String instantActiveDocId,String roomId, RollCallStatus callStatus) {
            this.rollCallId = rollCallId;
            this.employeeId = employeeId;
            this.callStatus = callStatus;
            this.roomId = roomId;
            this.instantActiveDocId = instantActiveDocId;
        }

        public static RollCallReplyEmployeeCommandItem create(Long rollCallId,String employeeId, String instantActiveDocId,String roomId, RollCallStatus callStatus) {
            return new RollCallReplyEmployeeCommandItem(rollCallId, employeeId, instantActiveDocId, roomId,callStatus);
        }
    }
}
