package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import lombok.Data;

@Data
public class RemoveUserCommand extends CommandAbstract {
    private final Long roomId;
    private final String tencentUserId;

    private RemoveUserCommand(Long roomId, String tencentUserId){
        this.roomId = roomId;
        this.tencentUserId = tencentUserId;
    }

    public static RemoveUserCommand create(Long roomId, String tencentUserId){
        return new RemoveUserCommand(roomId,tencentUserId);
    }
}
