package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.enums.ContentType;
import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import lombok.Getter;

@Getter
public class CreateTenantWarnContentCommand extends CommandAbstract {
    private final ContentType contentType;
    private final String referenceNumber;
    private final String content;

    public CreateTenantWarnContentCommand(ContentType contentType, String referenceNumber, String content) {
        this.contentType = contentType;
        this.referenceNumber = referenceNumber;
        this.content = content;
    }

    public static CreateTenantWarnContentCommand create(ContentType contentType, String referenceNumber, String content) {
        return new CreateTenantWarnContentCommand(contentType, referenceNumber, content);
    }
}
