package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class CreateTenantAccountCommand extends CommandAbstract {

    private final Boolean sosEnabled;

    private final String sosKey;
    private final String deviceNo;
    private final String creatorId;
    private final String creatorName;
    private final DispatchAccountType accountType;

    public CreateTenantAccountCommand(
            DispatchAccountType accountType,
            Boolean sosEnabled, String sosKey,
                                      String deviceNo,
                                      String creatorId, String creatorName) {
        this.sosEnabled = sosEnabled;
        this.sosKey = sosKey;
        this.deviceNo = deviceNo;
        this.creatorId = creatorId;
        this.creatorName = creatorName;
        this.accountType = accountType;
    }

    @Override
    public void validate() {
        super.validate();

        if (this.getSosEnabled() == null) {
            throw new BadTenantException("Sos设备是否开启不能为空!");
        }

        if (!StringUtils.hasLength(this.getSosKey()) && this.getSosEnabled()) {
            throw new BadTenantException("Sos设备是否开启为True的情况下SosKey不能为空！");
        }
    }

    public static CreateTenantAccountCommand create(
            DispatchAccountType accountType,
            Boolean sosEnabled,
            String sosKey,
            String deviceNo,
            String creatorId,
            String creatorName
    ) {
        CreateTenantAccountCommand command = new CreateTenantAccountCommand(
                accountType,
                sosEnabled,
                sosKey, deviceNo, creatorId, creatorName);
        return command;
    }
}
