package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import lombok.Getter;

@Getter
public class CreateProjectRoadmapCommand extends CommandAbstract {
    private final String name;
    private final Object roadmapImage;
    private final String projectId;
    private final Object roadmap;
    private final String organizationId;
    private final String organizationName;
    private final String operatorId;

    public CreateProjectRoadmapCommand(String name, Object roadmapImage, String projectId,
                                       Object roadmap, String organizationId,
                                       String organizationName, String operatorId) {
        this.name = name;
        this.roadmapImage = roadmapImage;
        this.projectId = projectId;
        this.roadmap = roadmap;
        this.organizationId = organizationId;
        this.organizationName = organizationName;
        this.operatorId = operatorId;
    }

    public static CreateProjectRoadmapCommand create(String name, Object roadmapImage, String projectId,
                                                     Object roadmap, String organizationId,
                                                     String organizationName, String operatorId) {
        return new CreateProjectRoadmapCommand(name, roadmapImage, projectId, roadmap, organizationId, organizationName, operatorId);
    }
}
