package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.*;
import com.bcxin.tenant.open.infrastructures.models.AgentHeaderOptionValue;
import lombok.Getter;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * 新增签到签退
 */
@Getter
public class CreateAttendanceCommand extends CommandAbstract {
    private final String tenantEmployeeId;
    private final ReferenceType referenceType;
    private final String referenceNumber;
    private final String note;
    private final String address;
    private final RecordStatus recordStatus;;
    private final GeoPointValueType lonLat;

    private final Collection<String> attachments;

    private final AgentHeaderOptionValue headerOptionValue;

    private final Map<String, Object> items;

    public CreateAttendanceCommand(String tenantEmployeeId, ReferenceType referenceType, String referenceNumber,
                                   String note, String address, RecordStatus recordStatus,
                                   GeoPointValueType lonLat,
                                   Collection<String> attachments,
                                   Map<String, Object> items,
                                   AgentHeaderOptionValue headerOptionValue) {
        this.tenantEmployeeId = tenantEmployeeId;
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.note = note;
        this.address = address;
        this.recordStatus = recordStatus;
        this.lonLat = lonLat;
        this.attachments = attachments;
        this.items = items;
        this.headerOptionValue = headerOptionValue;
    }


    public static CreateAttendanceCommand create(String tenantEmployeeId,
                                                 ReferenceType referenceType, String referenceNumber,
                                                 String note, String address, RecordStatus recordStatus,
                                                 GeoPointValueType lonLat,
                                                 Collection<String> attachments,
                                                 Map<String, Object> items,
                                                 AgentHeaderOptionValue headerOptionValue) {
        return new CreateAttendanceCommand(
                tenantEmployeeId, referenceType, referenceNumber,
                note, address, recordStatus, lonLat,attachments, items,headerOptionValue);
    }
}
