package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import lombok.Getter;

import java.util.Collection;

@Getter
public class BatchUpdateEmployeeLocationCommand extends CommandAbstract {

    private final Collection<EmployeeLocation> locations;

    public BatchUpdateEmployeeLocationCommand(Collection<EmployeeLocation> locations) {
        this.locations = locations;
    }

    public static BatchUpdateEmployeeLocationCommand create(Collection<EmployeeLocation> locations) {
        return new BatchUpdateEmployeeLocationCommand(locations);
    }

    @Getter
    public static class EmployeeLocation extends CommandAbstract {
        private final String id;
        private final DutySignInType signInType;
        private final Double lon;
        private final Double lat;

        public EmployeeLocation(String id, DutySignInType signInType,
                                Double lon, Double lat) {
            this.id = id;
            this.signInType = signInType;
            this.lon = lon;
            this.lat = lat;
        }

        public static EmployeeLocation create(String id, DutySignInType signInType,
                                              Double lon, Double lat) {
            return new EmployeeLocation(id, signInType, lon, lat);
        }
    }
}
