package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.criterias.CompanyAdvanceCriteria;
import com.bcxin.tenant.open.domains.criterias.RdCompanyCriteria;
import com.bcxin.tenant.open.domains.dtos.CompanyAdvanceDTO;
import com.bcxin.tenant.open.domains.entities.RdCompanyEntity;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;
import java.util.List;

public interface RdCompanyRepository extends RepositoryBase<RdCompanyEntity> {
    Collection<RdCompanyEntity> find(RdCompanyCriteria criteria);

    Collection<RdCompanyEntity> getByPage(Collection<String> ids, int pageIndex, int pageSize);

    RdCompanyEntity getByNoPkId(String id);

    Collection<String> getCompanyIds(int pageIndex, int pageSize);

    EntityCollection<CompanyAdvanceDTO> findByStations(CompanyAdvanceCriteria criteria);

    List<String> selectAllCompanyIds();
}