package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.criterias.DispatchLogSearchCriteria;
import com.bcxin.tenant.open.domains.criterias.MyDispatchLogRecordCriteria;
import com.bcxin.tenant.open.domains.criterias.SponsorDispatchLogSearchCriteria;
import com.bcxin.tenant.open.domains.dtos.SponsorDispatchLogDTO;
import com.bcxin.tenant.open.domains.entities.DeviceCommunicatedLogEntity;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;

public interface DeviceCommunicatedLogRepository extends RepositoryBase<DeviceCommunicatedLogEntity> {
    EntityCollection<DeviceCommunicatedLogEntity> search(DispatchLogSearchCriteria criteria);

    void batchInsert(Collection<DeviceCommunicatedLogEntity> logs);

    DeviceCommunicatedLogEntity getByNoPkId(String id);

    Collection<SponsorDispatchLogDTO> search(SponsorDispatchLogSearchCriteria criteria);
}