package com.bcxin.tenant.open.domains.readers;

import com.bcxin.tenant.open.document.domains.dtos.RdCompanyCountOfSecurityManDTO;
import com.bcxin.tenant.open.document.domains.dtos.RdCompanyCountOfStationDTO;
import com.bcxin.tenant.open.domains.criterias.ProjectRoadmapCriteria;
import com.bcxin.tenant.open.domains.dtos.ProjectRoadmapDTO;
import com.bcxin.tenant.open.domains.dtos.SecurityStationSuperviseDTO;
import com.bcxin.tenant.open.domains.views.RdDeviceDeskServiceScopeView;
import com.bcxin.tenant.open.domains.views.RdTenantUserAccountView;
import com.bcxin.tenant.open.infrastructures.EntityCollection;

import java.util.Collection;

public interface RdCompositedReader {

    Collection<RdDeviceDeskServiceScopeView> getByEmployeeIds(Collection<String> employeeIds);

    RdTenantUserAccountView getUserById(String employeeId);

    Collection<SecurityStationSuperviseDTO> getValidSecurityStationSupervisesByEmployeeIds(Collection<String> employeeIds);

    Long getCountOfSecurityManByOrganizationId(String organizationId);

    Long getCountOfSecurityManByStationId(String stationId);

    Long getCountOfActivityStationByOrganizationId(String organizationId);

    Collection<RdCompanyCountOfSecurityManDTO> getCountOfSecurityManByOrganizationIds(Collection<String> organizationIds);

    Collection<RdCompanyCountOfStationDTO> getCountOfStationByOrganizationIds(Collection<String> organizationIds);

    EntityCollection<ProjectRoadmapDTO> search(ProjectRoadmapCriteria criteria);

    Collection<RdDeviceDeskServiceScopeView> getSuperiorDeskByBoundEmployeeIds(Collection<String> employeeIds);
}
