package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

/**
 * 关闭房间的时间表:
 *  实时数据通过监听这个数据来实现通讯日志及计费的实时计算
 */
@TableName(value = "tencent_close_room_events")
@Data
public class TencentCloseRoomEventEntity extends EntityAbstract {
    @TableId(value = "id")
    private Long id;

    @TableField(value = "event_type")
    private int eventType;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "processed_status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ProcessedStatus status;

    @TableField(value = "last_processed_time")
    private Timestamp lastProcessedTime;

    @TableField(value = "last_processed_result")
    private String lastProcessedResult;

    @TableField(value = "room_id")
    private String roomId;

    public TencentCloseRoomEventEntity() {
        this.createdTime = Timestamp.from(Instant.now());
    }

    public static TencentCloseRoomEventEntity create(int eventType)
    {
        return new TencentCloseRoomEventEntity();
    }
}
