package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.entities.valueTypes.GeoPointValueType;
import com.bcxin.tenant.open.domains.typeHandlers.GeoPointTypeHandler;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@TableName(value = "tenant_employee_attendance_records", autoResultMap = true)
@Data
public class TenantEmployeeAttendanceEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private Long id;

    @TableField(value = "status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RecordStatus recordStatus;

    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ReferenceType referenceType;

    @TableField(value = "reference_number")
    private String referenceNumber;

    @TableField(value = "tenant_employee_id")
    private String tenantEmployeeId;

    @TableField(value = "tenant_user_id")
    private String tenantUserId;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "lon_lat", typeHandler = GeoPointTypeHandler.class)
    private GeoPointValueType lonLat;

    @TableField(value = "note")
    private String note;

    @TableField(value = "address")
    private String address;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "name")
    private String name;

    @TableField(value = "idCard_no")
    private String idCardNo;

    @TableField("company_name")
    private String companyName;

    @TableField("security_station_name")
    private String securityStationName;

    @TableField("security_station_address")
    private String securityStationAddress;

    @TableField("supervise_depart_id")
    private String superviseDepartId;

    @TableField("supervise_depart_name")
    private String superviseDepartName;

    @TableField(value = "security_certificate_no")
    private String securityCertificateNo;

    @TableField(value = "project_id")
    private String projectId;

    @TableField(value = "project_name")
    private String projectName;

    @TableField(value = "attachments")
    private String attachments;

    /**
     * 聚合计算的资源信息
     */
    @TableField(value = "calculated_resource_type")
    private int calculatedResourceType;

    @TableField(value = "header_agent")
    private String headerAgent;

    @TableField(value = "extend_json_info")
    private String extendJsonInfo;
}
