package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import lombok.Data;
import org.springframework.data.annotation.Id;

import java.sql.Timestamp;

/**
 * 人员与各个点的关系
 */
@TableName(value = "rd_work_station_users",autoResultMap = true)
@Data
public class RdWorkstationUserEntity extends EntityAbstract implements Aggregate {

    @Id
    private Long id;

    @TableField("employee_id")
    private String employeeId;

    /**
     * 最后同步时间
     */
    @TableField(value = "last_sync_time")
    private Timestamp lastSyncTime;

    /**
     * 驻勤点/岗点Id或者任务Id
     * 与rd_work_stations中的reference_number对应关系
     */
    @TableField(value = "reference_number")
    private String referenceNumber;

    /**
     * 因为类型: 驻勤点, 岗点, 点位
     */
    @TableField(value = "reference_type")
    private ReferenceType referenceType;
}
