package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ExamType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@TableName(value = "rd_system_exam_info_summary",autoResultMap = true)
@Data
public class RdSystemExamInfoEntity extends EntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    @TableField(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "begin_time")
    private Timestamp beginTime;

    @TableField(value = "end_time")
    private Timestamp endTime;

    /**
     * 考试类型
     */
    @TableField(value = "exam_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ExamType examType;

    /**
     * 选中的监考老师列表
     */
    @TableField(value = "teacher_ids")
    private String teacherIds;

    /**
     * 关联的考场的Id
     */
    @TableField(value = "exam_site_room_id")
    private String examSiteRoomId;

    @TableField(value = "last_sync_time")
    private Timestamp lastSyncTime;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;
}