package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import lombok.Data;

import java.sql.Timestamp;

/**
 * 考场信息
 */
@TableName(value = "rd_exam_site_room_summary",autoResultMap = true)
@Data
public class RdExamSiteRoomEntity extends RdSuperviseEntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    /**
     * 考场Id
     */
    @TableField(value = "id")
    private String id;

    /**
     * 考场名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 经纬度
     */
    @TableField(value = "lon_lat")
    private String lonLat;

    /**
     * 考试点Id
     */
    @TableField(value = "exam_site_id")
    private String examSiteId;

    /**
     * 考试点名称
     */
    @TableField(value = "exam_site_name")
    private String examSiteName;

    /**
     * 容纳的人员数量
     */
    @TableField(value = "capacity_of_person")
    private int capacityOfPerson;

    /**
     * 有效范围; 多少米
     */
    @TableField(value = "scope_range")
    private String scopeRange;

    /**
     * 考场状态
     * true: 启用
     * false: 禁用
     */
    @TableField(value = "status")
    private boolean status;

    /**
     * 企业Id
     */
    @TableField(value = "organization_id")
    private String organizationId;

    /**
     * 所属企业
     */
    @TableField(value = "company_name")
    private String companyName;
}