package com.bcxin.tenant.open.domains.entities;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.enums.*;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "rd_employee_summary",autoResultMap = true)
@Data
public class RdEmployeeEntity extends RdSuperviseEntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    @TableField(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "idCard_no")
    private String idCardNo;

    @TableField(value = "head_photo")
    private String headPhoto;

    @TableField(value = "contact")
    private String contact;

    @TableField(value = "company_name")
    private String companyName;

    /**
     * 无法使用枚举, 因为这边按照多个级别来设计的
     */
    @TableField(value = "company_level")
    private int cLevel;

    @TableField(value = "status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private EmploymentStatus status;

    @TableField(value = "checked_status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private UserCheckedStatus checkedStatus;

    @TableField(value = "authenticated_status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private RealNameAuthenticatedStatus authenticatedStatus;

    @TableField(value = "duty_status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DutySignInType dutyStatus;

    @TableField(value = "military_status")
    private String militaryStatus;

    @TableField(value = "security_certificate_no")
    private String securityCertificateNo;

    @TableField(value = "lon_lat")
    private String lonLat;

    @TableField(value = "occupation_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private OccupationType occupationType;

    @TableField(value = "hired_date")
    private Timestamp hiredDate;

    @TableField(value = "leave_time")
    private Timestamp leaveTime;

    @TableField(value = "insure")
    private boolean insure;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "tenant_user_id")
    private String tenantUserId;

    @TableField(value = "tenant_employee_id")
    private String tenantEmployeeId;

    @TableField(value = "device_number")
    private String deviceNumber;

    @TableField(value = "tenant_im_user_id")
    private String tenantImUserId;

    @TableField(value = "security_station_id")
    private String securityStationId;

    @TableField(value = "security_station_type")
    private String securityStationType;

    @TableField(value = "security_station_name")
    private String securityStationName;

    @TableField(value = "responsible_of_station_id")
    private String responsibleOfStationId;

    /**
     * 驻勤点对应的业务类型:
     * 驻勤点/社区警务/内保驻勤点/临保岗点
     */
    @TableField(value = "resource_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ResourceType resourceType;

    @TableField(value = "cid")
    private String cId;

    @TableField(value = "sex", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private Sex sex;

    /**
     * 企业的行业类型
     */
    @TableField(value = "industry")
    private String industry;

    /**
     * 企业的机构类型
     */
    @TableField(value = "institutional")
    private String institutional;

    /**
     * 是否是组织管理员
     */
    @TableField(value = "is_domain_admin")
    private boolean domainAdmin;

    /**
     * 岗位信息;
     * 比如: 群防群治的民警，社会力量等
     */
    @TableField(value = "position")
    private String position;

    /**
     * 第三方机构信息;
     * 比如: 马拉松中志愿者来自的单位信息
     */
    @TableField(value = "third_party")
    private String thirdParty;

    /**
     * 0 表示智能人事;
     * 1 表示来自赛演
     */
    @TableField(value = "source_party")
    private int sourceParty;

    public RdEmployeeEntity() {
        this.setStatus(EmploymentStatus.OnJob);
        this.setDutyStatus(DutySignInType.None);
        this.setOccupationType(OccupationType.Normal);
        this.setCheckedStatus(UserCheckedStatus.None);
        this.setAuthenticatedStatus(RealNameAuthenticatedStatus.UnAuthenticated);

        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void changeDeviceNumber(String deviceNumber) {
        this.setDeviceNumber(deviceNumber);
    }
}
