package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeviceReadyStatus;
import com.bcxin.tenant.open.infrastructures.enums.DeviceStatus;
import com.bcxin.tenant.open.infrastructures.enums.DeviceType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

/**
 * 智能设备信息
 */
@TableName(value = "rd_device_summary",autoResultMap = true)
@Data
public class RdDeviceEntity extends EntityAbstract implements Aggregate {
    @TableId("pk_id")
    private Long pkId;

    @TableField(value = "id")
    private String id;

    @TableField(value = "dispatch_no")
    private String dispatchNo;

    @TableField(value = "device_no")
    private String deviceNo;

    @TableField(value = "device_uid")
    private String deviceUid;

    @TableField(value = "device_model")
    private String deviceModel;

    /**
     * 设备的就绪状态
     */
    @TableField(value = "device_ready_status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DeviceReadyStatus deviceReadyStatus;

    @TableField(value = "device_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DeviceType deviceType;

    @TableField(value = "device_status", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DeviceStatus deviceStatus;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "organization_name")
    private String organizationName;

    @TableField(value = "security_station_id")
    private String securityStationId;

    @TableField(value = "security_station_name")
    private String securityStationName;

    @TableField(value = "security_depart_id")
    private String securityDepartId;

    @TableField(value = "last_sync_time")
    private Timestamp lastSyncTime;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "lat")
    private String lat;

    @TableField(value = "lon")
    private String lon;
}
