package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.BillPaymentStatus;
import com.bcxin.tenant.open.infrastructures.enums.BillType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "bill_monthly", autoResultMap = true )
@Data
@EqualsAndHashCode(exclude = {"createdTime"})
public class MonthlyBillEntity extends EntityAbstract implements Aggregate,Cloneable {

    @TableField(value = "bill_id")
    private String billId;

    @TableField(value = "type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private BillType billType;

    @TableField(value = "organization_id")
    private String orgId;

    @TableField(value = "status",jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private BillPaymentStatus billPaymentStatus;

    @TableField(value = "paid_time")
    private Timestamp paidTime;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "month")
    private String month;

    @TableField(value = "amount")
    private Integer amount;

    @TableField(value = "paid_amount")
    private Integer paidAmount;

    @TableField(value = "count")
    private Integer count;

    @TableField(value = "bill_config")
    private String billConfig;

    @TableField(value = "is_ready")
    private  int isReady;

    public MonthlyBillEntity(){
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static MonthlyBillEntity create(
            String billId,
            BillType billType,
            String orgId,
            BillPaymentStatus billPaymentStatus,
            Timestamp paidTime,
            String month,
            Integer amount,
            Integer paidAmount,
            Integer count,
            String billConfig,
            int isReady
    ){
        MonthlyBillEntity monthlyBillEntity = new MonthlyBillEntity();
        monthlyBillEntity.setBillId(billId);
        monthlyBillEntity.setBillType(billType);
        monthlyBillEntity.setOrgId(orgId);
        monthlyBillEntity.setBillPaymentStatus(billPaymentStatus);
        monthlyBillEntity.setPaidTime(paidTime);
        monthlyBillEntity.setMonth(month);
        monthlyBillEntity.setAmount(amount);
        monthlyBillEntity.setPaidAmount(paidAmount);
        monthlyBillEntity.setCount(count);
        monthlyBillEntity.setBillConfig(billConfig);
        monthlyBillEntity.setIsReady(isReady);
        return monthlyBillEntity;
    }

    @Override
    public MonthlyBillEntity clone() throws CloneNotSupportedException {
        return (MonthlyBillEntity)super.clone();
    }
}
