package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;

@Data
@TableName(value = "employee_location_query_record")
public class EmployeeLocationQuerysEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "employee_id")
    private String employeeId;

    @TableField(value = "organization_id")
    private String organizationId;

    @TableField(value = "created_time")
    private Timestamp createTime;

    @TableField(value = "begin_time")
    private Timestamp beginTime;

    @TableField(value = "end_time")
    private Timestamp endTime;

    public EmployeeLocationQuerysEntity(){
        this.createTime = Timestamp.from(Instant.now());
    }

    public static EmployeeLocationQuerysEntity create(String employeeId,
                                                      String organizationId,
                                                      Timestamp beginTime,
                                                      Timestamp endTime){
        EmployeeLocationQuerysEntity entity = new EmployeeLocationQuerysEntity();
        entity.setEmployeeId(employeeId);
        entity.setOrganizationId(organizationId);
        entity.setBeginTime(beginTime);
        entity.setEndTime(endTime);
        return entity;
    }
}
