package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

/**
 * https://kvi9mvrp7j.feishu.cn/docx/QV3LdrbVsoompUxYAdHcY4Ynn0c
 */
@Data
@TableName(value = "tlk_device_comminicated_log",autoResultMap = true)
public class DeviceCommunicatedLogEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "ITEM_PK_ID")
    private Long pkId;
    /**
     * 唯一
     */
    @TableId("ID")
    private String id;

    @TableField(value = "ITEM_BEGIN_TIME")
    private Timestamp beginTime;
    @TableField(value = "ITEM_END_TIME")
    private Timestamp endTime;
    /**
     * {0,语音},{1, 视频}
     */
    @TableField(value = "ITEM_TYPE", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private CommunicatedType communicatedType;
    @TableField(value = "ITEM_CALLER_USER_ID")
    /**
     * 发起者
     */
    private String callerUserId;
    /**
     * 发起人公司
     */
    @TableField(value = "ITEM_CALLER_COMPANY_NAME")
    private String callerCompanyName;
    @TableField(value = "ITEM_CALLER_USER_NAME")
    /**
     * 发起者姓名
     */
    private String callerUserName;

    /**
     * 调用者音视频 id(调度台Id)
     */
    @TableField(value = "ITEM_CALLER_DEVICE_PK_ID")
    private String callerDevicePkId;
    /**
     * 调用者音视频 no(调度台no)
     */
    @TableField(value = "ITEM_CALLER_DEVICE_NO")
    private String callerDeviceNo;
    @TableField(value = "ITEM_CALLED_DOMAIN_ID")
    private String calledDomainId;
    @TableField(value = "ITEM_DOMAIN_ID")
    private String domainId;

    @TableField(value = "DOMAINID")
    private String callerDomainId;

    @TableField(value = "ITEM_CALLED_JSON")
    private String calledJson;
    /**
     * 调度时间
     */
    @TableField(value = "ITEM_DISPATCH_TIME")
    private int dispatchTimeInMinutes;
    @TableField(value = "ITEM_CONSUME_VALUE")
    private int points;
    @TableField(value = "ITEM_CALLED_COMPANY_NAME")
    private String calledCompanyName;

    @TableField(value = "FORMID")
    private String formId;
    @TableField(value = "LASTMODIFIED")
    private Timestamp lastModified;
    @TableField(value = "CREATED")
    private Timestamp created;
    @TableField(value = "ITEM_CREATED_TIME")
    private Timestamp createdTime;

    /**
     * 房间号
     */
    @TableField(value = "ITEM_ROOM_ID")
    private String roomId;

    /**
     * 调度原因
     */
    @TableField(value = "ITEM_REFERENCE_TYPE", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DispatchReasonType referenceType;

    /**
     * 调度的引用Id
     */
    @TableField(value = "ITEM_REFERENCE_NUMBER")
    private String referenceNumber;

    /**
     * 是否为发起方付钱
     */
    @TableField(value = "ITEM_IS_PAID_BY_CALLER")
    private boolean paidByCaller;

    /**
     * 调度方的机构类型
     */
    @TableField(value = "ITEM_CALLER_ORG_INSTITUTIONAL")
    private String callerOrgInstitutional;

    /**
     * 调度台类型
     */
    @TableField(value = "desk_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private DeskType deskType;


    @TableField(value = "ITEM_PROJECT_ID")
    private String projectId;

    @TableField(value = "ITEM_PROJECT_Name")
    private String projectName;

    protected DeviceCommunicatedLogEntity(){}

    public DeviceCommunicatedLogEntity(Long pkId, String idPrefix) {
        this.setFormId("__zJyCxXABuSlpZLpPSDy");
        this.setId(String.format("%s--%s", idPrefix, this.getFormId()));
        this.setPkId(pkId);
        this.setLastModified(Timestamp.from(Instant.now()));
    }

    public static DeviceCommunicatedLogEntity create(
            DeskType deskType,
            Long pkId, String idPrefix, Timestamp beginTime, Timestamp endTime,
            CommunicatedType communicatedType, String callerUserId,
            String callerUserName, String callerCompanyName,
            String callerDevicePkId, String callerDeviceNo, String calledDomainId, String callerDomainId,
            int dispatchTimeInMinutes,
            int points, String calledCompanyName,
            String roomId,
            DispatchReasonType referenceType,
            String referenceNumber,
            boolean isPaidByCaller,
            String callerOrgInstitutional
    ) {
        DeviceCommunicatedLogEntity communicatedLog = new DeviceCommunicatedLogEntity(pkId, idPrefix);
        communicatedLog.setDeskType(deskType);

        /**
         * 将创建时间设置为调度的开始时间
         */
        communicatedLog.setCreatedTime(beginTime);
        communicatedLog.setCreated(communicatedLog.getCreatedTime());
        communicatedLog.setCommunicatedType(communicatedType);
        communicatedLog.setCallerDeviceNo(callerDeviceNo);
        communicatedLog.setBeginTime(beginTime);
        communicatedLog.setEndTime(endTime);
        communicatedLog.setCallerUserId(callerUserId);
        communicatedLog.setCallerUserName(callerUserName);
        communicatedLog.setCallerCompanyName(callerCompanyName);
        communicatedLog.setCallerDevicePkId(callerDevicePkId);
        communicatedLog.setCalledDomainId(calledDomainId);
        communicatedLog.setDomainId(callerDomainId);
        communicatedLog.setCallerDomainId(callerDomainId);
        communicatedLog.setDispatchTimeInMinutes(dispatchTimeInMinutes);
        communicatedLog.setPoints(points);
        communicatedLog.setCalledCompanyName(calledCompanyName);

        communicatedLog.setRoomId(roomId);
        communicatedLog.setReferenceType(referenceType);
        communicatedLog.setReferenceNumber(referenceNumber);
        communicatedLog.setPaidByCaller(isPaidByCaller);
        communicatedLog.setCallerOrgInstitutional(callerOrgInstitutional);

        return communicatedLog;
    }
}
