package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "bill_payment_record")
@Data
public class BillPaymentRecordEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "bill_id")
    private String billId;

    @TableField(value = "paid_amount")
    private Integer paidAmount;

    @TableField(value = "organization_id")
    private String orgId;

    @TableField(value = "paid_time")
    private Timestamp paidTime;

    public BillPaymentRecordEntity(){
        this.paidTime = Timestamp.from(Instant.now());
    }

    public static BillPaymentRecordEntity create(String billId,
                                                 Integer paidAmount,
                                                 String orgId){
        BillPaymentRecordEntity entity = new BillPaymentRecordEntity();
        entity.setBillId(billId);
        entity.setPaidAmount(paidAmount);
        entity.setOrgId(orgId);
        return entity;
    }
}
