package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Date;

@Data
public class PoliceIncidentSearchCriteria extends CriteriaAbstract {
    private Collection<DeskType> deskTypes;
    private String policeName;
    private Date beginTime;
    private Date endTime;
    private Integer eventType;
    private Collection<PoliceEventCategory> categories;
    private String empName;
    private String empIdNumber;
    private String contact;
    private String organizationName;
    private String stationName;
    private Collection<String> superDepartIds;
    private Date beginProcessedTime;
    private Date endProcessedTime;
    private String processorName;
    private PoliceEventStatus status;
    private Collection<String> organizationIds;
    private boolean supervise;
    private String employeeId;
    private String projectName;
    private Collection<String> managedProjectIds;
    private boolean hasManagedProjectIds;

    private PoliceEventLevel level;

    private String reason;

    private String regionName;

    /**
     * 其他特殊权限范围
     */
    private Collection<String> otherSpecialPermissionScopeIds;

    public PoliceIncidentSearchCriteria(
            int pageIndex, int pageSize,
            Collection<DeskType> deskTypes,
            Collection<String> organizationIds,
            String employeeId,
            boolean supervise,
            Collection<PoliceEventCategory> categories,
            String policeName,
            Date beginTime,
            Date endTime,
            Integer eventType,
            String empName,
            String empIdNumber,
            String contact,
            String organizationName,
            String stationName,
            Collection<String> superDepartIds,
            Date beginProcessedTime,
            Date endProcessedTime,
            String processorName,
            PoliceEventStatus status,
            Collection<String> otherSpecialPermissionScopeIds,
            String projectName,
            Collection<String> managedProjectIds,
            PoliceEventLevel level,
            String reason,
            String regionName) {
        super(pageIndex, pageSize);
        this.deskTypes = deskTypes;

        this.setCategories(categories);
        this.setPoliceName(policeName);
        this.setBeginTime(beginTime);
        this.setEndTime(endTime);
        this.setEventType(eventType);

        this.setEmpName(empName);
        this.setEmpIdNumber(empIdNumber);
        this.setOrganizationName(organizationName);
        this.setContact(contact);
        this.setStationName(stationName);
        this.setSuperDepartIds(superDepartIds);
        this.setBeginProcessedTime(beginProcessedTime);
        this.setEndProcessedTime(endProcessedTime);
        this.setProcessorName(processorName);
        this.setStatus(status);
        this.setOrganizationIds(organizationIds);
        this.setEmployeeId(employeeId);
        this.setSupervise(supervise);
        this.setOtherSpecialPermissionScopeIds(otherSpecialPermissionScopeIds);
        this.setProjectName(projectName);
        this.setManagedProjectIds(managedProjectIds);
        this.setLevel(level);
        this.setReason(reason);
        this.setRegionName(regionName);

        this.hasManagedProjectIds = !CollectionUtils.isEmpty(this.getManagedProjectIds());
    }

    public static PoliceIncidentSearchCriteria create(
            int pageIndex, int pageSize,
            Collection<DeskType> deskTypes,
            Collection<String> organizationIds,
            String employeeId,
            boolean supervise,
            Collection<PoliceEventCategory> categories,
            String policeName,
            Date beginTime,
            Date endTime,
            Integer eventType,
            String empName,
            String empIdNumber,
            String contact,
            String organizationName,
            String stationName,
            Collection<String> superDepartIds,
            Date beginProcessedTime,
            Date endProcessedTime,
            String processorName,
            PoliceEventStatus status,
            Collection<String> otherSpecialPermissionScopeIds,
            String projectName,
            Collection<String> managedProjectIds,
            PoliceEventLevel level,
            String reason,
            String regionName
    ) {
        PoliceIncidentSearchCriteria criteria =
                new PoliceIncidentSearchCriteria(
                        pageIndex, pageSize,
                        deskTypes,
                        organizationIds,
                        employeeId,
                        supervise,
                        categories,
                        policeName, beginTime, endTime, eventType, empName, empIdNumber, contact,
                        organizationName, stationName, superDepartIds, beginProcessedTime,
                        endProcessedTime, processorName, status,
                        otherSpecialPermissionScopeIds,
                        projectName,
                        managedProjectIds,
                        level,
                        reason,
                        regionName
                );

        return criteria;
    }
}
