package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import lombok.Getter;

import java.util.Collection;
import java.util.Date;

@Getter
public class AttendanceAdvanceDetailCriteria extends AttendanceAdvanceCriteria {
    private final String employeeId;

    public AttendanceAdvanceDetailCriteria(
            int pageIndex,
            int pageSize,
            Collection<DeskType> deskTypes,
            String projectName,
            String projectCompanyName,
            Integer calculatedResourceType,
            String employeeId,
            String name, String companyName,
            String securityStationName,
            Collection<String> superviseDepartIds,
            Date createdStarDate, Date createdEndDate,
            String idCardNo, Collection<String> organizationIds,
            Boolean hasSecurityCertificateNo,
            Collection<RecordStatus> recordStatuses,
            Collection<String> otherSpecialPermissionScopeIds,
            Collection<String> projectIds
            ) {
        super(pageIndex, pageSize, deskTypes,name, companyName, projectName,projectCompanyName,securityStationName, superviseDepartIds, createdStarDate,
                createdEndDate, idCardNo, organizationIds, hasSecurityCertificateNo, recordStatuses,otherSpecialPermissionScopeIds,
                calculatedResourceType,projectIds);

        this.employeeId = employeeId;
    }

    public static AttendanceAdvanceDetailCriteria create(int pageIndex,
                                                         int pageSize,
                                                         Collection<DeskType> deskTypes,
                                                         String projectName,
                                                         String projectCompanyName,
                                                         Integer calculatedResourceType,
                                                         String employeeId,
                                                         String name, String companyName,
                                                         String securityStationName,
                                                         Collection<String> superviseDepartIds,
                                                         Date createdStarDate, Date createdEndDate,
                                                         String idCardNo, Collection<String> organizationIds,
                                                         Boolean hasSecurityCertificateNo,
                                                         Collection<RecordStatus> recordStatuses,
                                                         Collection<String> otherSpecialPermissionScopeIds,
                                                         Collection<String> projectIds
                                                         ) {
        return new AttendanceAdvanceDetailCriteria(
                pageIndex, pageSize,
                deskTypes,projectName,projectCompanyName,calculatedResourceType,
                employeeId,
                name, companyName, securityStationName, superviseDepartIds,
                createdStarDate, createdEndDate, idCardNo, organizationIds,
                hasSecurityCertificateNo, recordStatuses,otherSpecialPermissionScopeIds,
                projectIds);
    }
}
