package com.bcxin.tenant.open.domains.utils;

/**
 * 腾讯音视频功能
 */
public class TencentConstants {
    /**
     * 创建房间
     */
    public static final int EVENT_TYPE_CREATE_ROOM = 101;
    /**
     * 解散房间
     */
    public static final int EVENT_TYPE_DISMISS_ROOM = 102;
    /**
     * 进入房间
     */
    public static final int EVENT_TYPE_ENTER_ROOM = 103;
    /**
     * 退出房间
     */
    public static final int EVENT_TYPE_EXIT_ROOM = 104;
    /**
     * 切换角色
     */
    public static final int EVENT_TYPE_CHANGE_ROLE = 105;
    /**
     * 开始推送视频数据
     */
    public static final int EVENT_TYPE_START_VIDEO = 201;
    /**
     * 停止推送视频数据
     */
    public static final int EVENT_TYPE_STOP_VIDEO = 202;
    /**
     * 开始推送音频数据
     */
    public static final int EVENT_TYPE_START_AUDIO = 203;
    /**
     * 停止推送音频数据
     */
    public static final int EVENT_TYPE_STOP_AUDIO = 204;
    /**
     * 开始推送辅路数据
     */
    public static final int EVENT_TYPE_START_ASSIT = 205;
    /**
     * 停止推送辅路数据
     */
    public static final int EVENT_TYPE_STOP_ASSIT = 206;

    public static boolean filterRoomLifecycle(long eventType) {
        //return eventType.equals(EVENT_TYPE_CREATE_ROOM) || eventType.equals(EVENT_TYPE_DISMISS_ROOM);
        return eventType == EVENT_TYPE_CREATE_ROOM || eventType == EVENT_TYPE_DISMISS_ROOM;
    }

    public static boolean filterStartRoom(long eventType) {
        return eventType == (EVENT_TYPE_CREATE_ROOM);
    }

    public static boolean filterEndRoom(long eventType) {
        return eventType == (EVENT_TYPE_DISMISS_ROOM);
    }

    public static boolean filterEnterRoom(long eventType) {
        return eventType == (EVENT_TYPE_ENTER_ROOM);
    }

    public static boolean filterExitRoom(long eventType) {
        return eventType == (EVENT_TYPE_EXIT_ROOM);
    }

    public static boolean filterStartVideoAudioAssit(long eventType) {
        return eventType == (EVENT_TYPE_START_VIDEO) ||
                eventType == (EVENT_TYPE_START_AUDIO) ||
                eventType == (EVENT_TYPE_START_ASSIT);
    }

    public static boolean filterStopVideoAudioAssit(long eventType) {
        return eventType == (EVENT_TYPE_STOP_VIDEO) ||
                eventType == (EVENT_TYPE_STOP_AUDIO) ||
                eventType == (EVENT_TYPE_STOP_ASSIT);
    }

    public static boolean filterMatchedStopVideoAudioAssit(Long eventType, Long currentEventType) {
        if (eventType == EVENT_TYPE_START_AUDIO) {
            return currentEventType == EVENT_TYPE_STOP_AUDIO;
        }

        if (eventType == EVENT_TYPE_START_VIDEO) {
            return currentEventType == EVENT_TYPE_STOP_VIDEO;
        }

        if (eventType == EVENT_TYPE_START_ASSIT) {
            return currentEventType == EVENT_TYPE_STOP_ASSIT;
        }

        return false;
    }
}
