package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import lombok.Getter;

/**
 * 验证签到签退
 */
@Getter
public class ValidateAttendanceCommand extends CommandAbstract {
    private final ReferenceType referenceType;
    private final String referenceNumber;

    public ValidateAttendanceCommand(ReferenceType referenceType, String referenceNumber) {
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
    }

    public static ValidateAttendanceCommand create(ReferenceType referenceType, String referenceNumber) {
        return new ValidateAttendanceCommand(referenceType, referenceNumber);
    }

    /*
    public ValidateAttendanceCommand(String tenantUserId, String tenantEmployeeId, String organizationId,ReferenceType referenceType, String referenceNumber,
                                     String note, String address, RecordStatus recordStatus,
                                     GeoPointValueType lonLat,
                                     AgentHeaderOptionValue headerOptionValue) {
        super(tenantUserId, tenantEmployeeId, organizationId,referenceType, referenceNumber, note, address, recordStatus,  lonLat, headerOptionValue);
    }

    public static ValidateAttendanceCommand create(String tenantUserId, String tenantEmployeeId, String organizationId,ReferenceType referenceType,
                                                   String referenceNumber, String note, String address, RecordStatus recordStatus,
                                                   GeoPointValueType lonLat,AgentHeaderOptionValue headerOptionValue) {
        return new ValidateAttendanceCommand(tenantUserId, tenantEmployeeId, organizationId, referenceType, referenceNumber, note, address,
                recordStatus, lonLat, headerOptionValue);
    }

     */
}
