package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.criterias.PoliceIncidentSearchCriteria;
import com.bcxin.tenant.open.domains.criterias.PoliceIncidentsSearchCriteria;
import com.bcxin.tenant.open.domains.criterias.PoliceIncidentRegionReportCriteria;
import com.bcxin.tenant.open.domains.dtos.PoliceIncidentPendingStatisticsDTO;
import com.bcxin.tenant.open.domains.dtos.PoliceIncidentRegionReportDTO;
import com.bcxin.tenant.open.domains.dtos.PoliceIncidentsSosUpdateDTO;
import com.bcxin.tenant.open.domains.entities.PoliceIncidentsEntity;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;

public interface PoliceIncidentsRepository extends RepositoryBase<PoliceIncidentsEntity> {
    PoliceIncidentsEntity getById(Object id);

    void insert(PoliceIncidentsEntity data);

    void update(PoliceIncidentsEntity data);

    EntityCollection<PoliceIncidentsEntity> search(PoliceIncidentsSearchCriteria criteria);

    void updateSsoStatus(PoliceIncidentsSosUpdateDTO data);

    EntityCollection<PoliceIncidentsEntity> search(PoliceIncidentSearchCriteria criteria);

    Collection<PoliceIncidentPendingStatisticsDTO> getPendingTotal(Collection<String> superviseDepartIds);

    void delete(PoliceIncidentsEntity data);

    Collection<PoliceIncidentRegionReportDTO> getReport(PoliceIncidentRegionReportCriteria criteria);
}
