package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.entities.MonthlyBillEntity;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;
import java.util.List;

public interface MonthlyBillRepository extends RepositoryBase<MonthlyBillEntity> {

    /**
     * 当生成月账单时，更新账单信息。（月账单在第一天计算日账单的时候，已经插入一条空数据）
     */
    void generateBills(List<MonthlyBillEntity> billEntityList);

    void updatePayment(String billId, Integer paidAmount);

    /**
     * 生成日账单时需要关联月度账单，这时插入一个空的月度账单
     * @param billEntityList
     */
    void insertEmptyBills(List<MonthlyBillEntity> billEntityList);

    List<MonthlyBillEntity> getByBillId(List<String> billIds);

    List<MonthlyBillEntity> getRequiredPaymentBillsByMonth(String month);

    List<MonthlyBillEntity> getRequiredPaymentBills();

    List<MonthlyBillEntity> getRequiredPaymentBillsByOrgs(Collection<String> orgIds);

    /**
     * 账单支付时，更新支付信息
     * @param billEntityList
     */
    void updatePaidAmount(List<MonthlyBillEntity> billEntityList);
}
