package com.bcxin.tenant.open.domains.repositories;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bcxin.tenant.open.domains.criterias.AttendanceAdvanceCriteria;
import com.bcxin.tenant.open.domains.criterias.AttendanceAdvanceDetailCriteria;
import com.bcxin.tenant.open.domains.criterias.AttendanceCriteria;
import com.bcxin.tenant.open.domains.criterias.MyAttendanceCriteria;
import com.bcxin.tenant.open.domains.dtos.AttendanceCompanyGroupDTO;
import com.bcxin.tenant.open.domains.dtos.AttendanceCompanyGroupDetailDTO;
import com.bcxin.tenant.open.domains.dtos.AttendanceRepDTO;
import com.bcxin.tenant.open.domains.dtos.MyAttendanceRecordDTO;
import com.bcxin.tenant.open.domains.entities.TenantEmployeeAttendanceEntity;
import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;
import java.util.Date;
import java.util.List;


public interface AttendanceRepository extends RepositoryBase<TenantEmployeeAttendanceEntity> {

    List<TenantEmployeeAttendanceEntity> getByDay(String tenantEmployeeId, String createdDate);

    void insert(TenantEmployeeAttendanceEntity data);

    void batchInsert(Collection<TenantEmployeeAttendanceEntity> data);

    void batchInsertForStation(Collection<TenantEmployeeAttendanceEntity> data);

    void batchInsertForJobStation(Collection<TenantEmployeeAttendanceEntity> data);

    IPage<AttendanceRepDTO> find(AttendanceCriteria criteria);

    TenantEmployeeAttendanceEntity getMaxItemByEmployeeId(String employeeId);

    Collection<TenantEmployeeAttendanceEntity> getEmployeeAttendances(String employeeId, Date beginDate, Date endDate);

    EntityCollection<TenantEmployeeAttendanceEntity> search(AttendanceCriteria criteria);

    EntityCollection<AttendanceCompanyGroupDTO> searchByAdvanceGroup(AttendanceAdvanceCriteria criteria);

    EntityCollection<AttendanceCompanyGroupDetailDTO> searchByAdvanceGroupDetail(AttendanceAdvanceDetailCriteria criteria);

    int cleanRecentlyRecords();

    Collection<MyAttendanceRecordDTO> search(MyAttendanceCriteria criteria);

    Collection<TenantEmployeeAttendanceEntity> getByTypeAndNumber(ReferenceType referenceType,String referenceNumber,int pageIndex,int pageSize);
}
