package com.bcxin.tenant.open.domains.events;

import com.bcxin.tenant.open.domains.entities.RollCallEmployeeEntity;
import lombok.Getter;

import java.util.Collection;

@Getter
public class BatchDispatchRollCallEmployeeEvent extends DomainEventAbstract {
    private final Collection<RollCallEmployeeEntity> employees;

    public BatchDispatchRollCallEmployeeEvent(Collection<RollCallEmployeeEntity> employees) {
        super(employees);
        this.employees = employees;
    }

    public static BatchDispatchRollCallEmployeeEvent create(Collection<RollCallEmployeeEntity> employees) {
        return new BatchDispatchRollCallEmployeeEvent(employees);
    }
}
