package com.bcxin.tenant.open.domains.eventListeners;

import com.bcxin.tenant.open.document.domains.documents.RollCallProgressStatusDocument;
import com.bcxin.tenant.open.document.domains.documents.RollCallProgressStatusDocument$;
import com.bcxin.tenant.open.document.domains.repositories.RollCallProgressStatusDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RollCallEmployeeEntity;
import com.bcxin.tenant.open.domains.events.ReplyRollCallEmployeeStatusEvent;
import com.redis.om.spring.search.stream.EntityStream;
import com.redis.om.spring.search.stream.SearchStream;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@Component
public class ReplyRollCallEmployeeStatusEventListener  implements ApplicationListener<ReplyRollCallEmployeeStatusEvent> {
    private final EntityStream entityStream;
    private final RollCallProgressStatusDocumentRepository rollCallProgressStatusDocumentRepository;

    public ReplyRollCallEmployeeStatusEventListener(EntityStream entityStream, RollCallProgressStatusDocumentRepository rollCallProgressStatusDocumentRepository) {
        this.entityStream = entityStream;
        this.rollCallProgressStatusDocumentRepository = rollCallProgressStatusDocumentRepository;
    }

    @Override
    public void onApplicationEvent(ReplyRollCallEmployeeStatusEvent event) {
        Collection<RollCallEmployeeEntity> selectedManuallyRollCallEmployees
                = event.getRollCallEmployees();

        if (!CollectionUtils.isEmpty(selectedManuallyRollCallEmployees)) {
            SearchStream<RollCallProgressStatusDocument> rollCallProgressStatusDocumentSearchStream =
                    this.entityStream.of(RollCallProgressStatusDocument.class);
            Long[] rollCallIds = selectedManuallyRollCallEmployees.stream()
                    .map(ii -> ii.getRollCallId())
                    .distinct().collect(Collectors.toList()).toArray(ix -> new Long[ix]);
            rollCallProgressStatusDocumentSearchStream = rollCallProgressStatusDocumentSearchStream
                    .filter(RollCallProgressStatusDocument$.ID.in(rollCallIds));

            Collection<RollCallProgressStatusDocument> documents =
                    rollCallProgressStatusDocumentSearchStream
                            .collect(Collectors.toList());

            for (Long rollCallId : rollCallIds) {
                RollCallProgressStatusDocument selectedDocument =
                        documents.stream().filter(ii -> ii.getId().equals(rollCallId))
                                .findFirst().orElse(null);
                if (selectedDocument != null) {
                    Collection<RollCallEmployeeEntity> selectedRollCallEmployees =
                            selectedManuallyRollCallEmployees.stream()
                                    .filter(ii -> ii.getRollCallId().equals(rollCallId))
                                    .collect(Collectors.toList());

                    selectedDocument.incrProcessed(selectedRollCallEmployees.size());
                }
            }

            this.rollCallProgressStatusDocumentRepository.saveAll(documents);
        }
    }
}
